@extends('layouts.admin')

@section('title', 'View Blog Post')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">{{ $blog->title }}</h1>
    <div class="d-flex gap-2">
        <a href="{{ route('admin.blogs.edit', $blog) }}" class="btn btn-warning">
            <i class="bi bi-pencil"></i> Edit
        </a>
        <a href="{{ route('admin.blogs.index') }}" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> Back to List
        </a>
    </div>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card mb-4">
            <div class="card-body">
                @if($blog->featured_image)
                    <img src="{{ asset('storage/' . $blog->featured_image) }}" alt="{{ $blog->title }}" class="img-fluid mb-3 rounded">
                @endif
                
                <div class="mb-3">
                    <strong>Excerpt:</strong>
                    <p class="text-muted">{{ $blog->excerpt ?? 'No excerpt provided' }}</p>
                </div>

                <div class="mb-3">
                    <strong>Content:</strong>
                    <div class="mt-2">{!! nl2br(e($blog->content)) !!}</div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Post Details</h5>
            </div>
            <div class="card-body">
                <p><strong>Slug:</strong><br><code>{{ $blog->slug }}</code></p>
                <p><strong>Author:</strong><br>{{ $blog->author ?? 'Not set' }}</p>
                <p><strong>Published Date:</strong><br>{{ $blog->published_at ? $blog->published_at->format('M d, Y') : 'Not set' }}</p>
                <p><strong>Status:</strong><br>
                    <span class="badge bg-{{ $blog->is_published ? 'success' : 'secondary' }}">
                        {{ $blog->is_published ? 'Published' : 'Draft' }}
                    </span>
                </p>
                <p><strong>Views:</strong><br>{{ $blog->views }}</p>
                <p><strong>Sort Order:</strong><br>{{ $blog->sort_order }}</p>
                
                @if($blog->meta_title)
                    <hr>
                    <p><strong>SEO Meta Title:</strong><br>{{ $blog->meta_title }}</p>
                @endif
                
                @if($blog->meta_description)
                    <p><strong>SEO Meta Description:</strong><br>{{ $blog->meta_description }}</p>
                @endif

                <hr>
                <p><strong>Created:</strong><br>{{ $blog->created_at->format('M d, Y h:i A') }}</p>
                <p><strong>Last Updated:</strong><br>{{ $blog->updated_at->format('M d, Y h:i A') }}</p>
            </div>
        </div>
    </div>
</div>
@endsection



